// types.h
// ----------------------------------------------------------------------------------
// Global Types for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// For machine portability all variables that need to be a specific size are 
// defined here.
// Global constants and types are likewise defined here.
// ----------------------------------------------------------------------------------
// History:
//		Clark Goble			08/09/94
//			Original.
//		CG					08/11/94
//			Added various definitions from spelldef.h.  Centralized
//			all the various commonly used macros and consts.
// ----------------------------------------------------------------------------------
#include "platform.h"

#ifndef _TSPELL_
#define _TSPELL_


#ifdef _MACINTOSH_
//#include <Desk.h>
#endif

#ifdef _WINDOWS_
#ifndef FioParam
#define FioParam char
#endif
#endif

#ifdef _MSDOS_
#ifndef FioParam
#define FioParam char
#endif
#endif

#ifdef _MACINTOSH_
#ifndef FioParam
#define FioParam FSSpec
#endif
#endif



// ----------------------------------------------------------------------------------
// Constants
// ----------------------------------------------------------------------------------

#define kMaxWordLength 40

// Boolean constants (used for clarity)
#define MATCH 		1
#define NOTMATCH 	0

#define FOUND  	1				// Found word in search
#define NOTFOUND  0				// Didn't find word in search

#ifndef	ERROR
#define ERROR  	0				// Error state returned
#endif

#ifndef OK
#define OK  		1					// No errors in filter
#endif

#ifndef TRUE
#define TRUE  		1
#define FALSE  	0
#endif

#ifndef OK
#define OK  		1
#endif

#ifndef DONE
#define DONE 		3
#endif

#ifndef NOTDONE
#define NOTDONE 	2
#endif

#define NOTOK  	0

#define YES  		1
#define NO  		0

// Error Numbers
#define eNo_Err					(0)
#define eNo_Mem  				(-1)
#define eOpening_File  			(-2)
#define eNot_Dictionary  		(-3)
#define eUser_Dict_Corrupted  	(-4)
#define eNot_Done  				(-5)
#define eDone  					(-6)
#define eGeneral 				(-7)
#define eReading_File			(-8)
#define eWriting_File			(-9)
#define eUnusableDict			(-10)
#define eNotSpeller				(-11)
#define eIllegalCmd				(-12)
#define eCancel					(-13)

// Leading trichar sequence

#define UPPER_UPPER_lower (1)
#define lower_UPPER_lower (2)
#define lower_UPPER_UPPER (3)
#define lower_lower_UPPER (4)
#define lower_UPPER       (5)
#define lower_case        (6)
#define UPPER_CASE        (7)
#define UPPER_lower		  (8)

#define WORD_DUPLICATED     (1)
#define WORD_NOT_DUPLICATED (0)

#define FILENAMELENGTHMAX         (40)

#define ERROR_OPENING_DICT         (1)
#define ERROR_WRITING_USER_WORD    (2)

#define IS_SPELLED_CORRECTLY       (1)
#define NOT_SPELLED_CORRECTLY      (2)


// Constants for a Bloom Filter

// number of iterations within bloom filter (accuracy)
#define NUMBLOOMFILTERPROBES     (17)

// page size of dictionary data
#define PAGESIZE               (2048)

// end of index flag
#define EOI                      (-4)


// ----------------------------------------------------------------------------------
// Types
// ----------------------------------------------------------------------------------

#ifndef SW_TYPES__
#define SW_TYPES__
typedef unsigned char UInt8;		// One byte

struct WordInfo {
	short	Case;
	short	Duplicate;
	short	Replace;
};
	  
typedef short (*CallBackProc)();

#endif

#endif
